#!/bin/bash

# Define the network interface
WLAN_INTERFACE="wlan0" # replace with your network interface name
WWAN_INTERFACE="wwan0"
HIGH_PRIORITY="100"
LOW_PRIORITY="200"

WLAN_PRIORITY=$(route -n | grep $WLAN_INTERFACE | head -n 1 | awk '{print $5}')
WWAN_PRIORITY=$(route -n | grep $WWAN_INTERFACE | head -n 1 | awk '{print $5}')

WLAN_INTERFACE_CONF=$(route -n | grep $WLAN_INTERFACE | head -n 1 | awk '{print $8}')
WWAN_INTERFACE_CONF=$(route -n | grep $WWAN_INTERFACE | head -n 1 | awk '{print $8}')



check_wlan() {
	if ping -q -c 1 -W 1 -I $WLAN_INTERFACE 8.8.8.8 >/dev/null; then
		return 0;
	else
		return 1
	fi
}




echo "${WLAN_INTERFACE_CONF}: ${WLAN_PRIORITY}, ${WWAN_INTERFACE_CONF}: ${WWAN_PRIORITY}"

if check_wlan; then
	if [ "$WLAN_PRIORITY" == "$HIGH_PRIORITY" ]; then
        	echo "wifi available, already using as priority"
	else
        	echo "change to use wifi as priority"
		systemctl restart NetworkManager.service
		ifmetric $WLAN_INTERFACE $HIGH_PRIORITY
		ifmetric $WWAN_INTERFACE $LOW_PRIORITY
		systemctl restart lora_pkt_fwd.service
	fi
else
        if [ "$WWAN_PRIORITY" == "$HIGH_PRIORITY" ]; then
                echo "no wifi, already using as lte as priority"
        else
                echo "change to use lte as priority"
		systemctl restart NetworkManager.service
                ifmetric $WWAN_INTERFACE $HIGH_PRIORITY
                ifmetric $WLAN_INTERFACE $LOW_PRIORITY
                systemctl restart lora_pkt_fwd.service
        fi
fi


